/*
 * Decompiled with CFR 0.152.
 */
package com.vistara.sdk.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    public static boolean isEmpty(String param) {
        if (param == null) {
            return true;
        }
        return "".equals(param.trim());
    }

    public static String trim(String param) {
        if (param == null) {
            return null;
        }
        return param.trim();
    }

    public static String trimLeft(String str) {
        int st;
        char[] val = str.toCharArray();
        for (st = 0; st < val.length && val[st] <= ' '; ++st) {
        }
        return str.substring(st);
    }

    public static String trimRight(String str) {
        int end;
        char[] val = str.toCharArray();
        for (end = val.length; end > 0 && val[end - 1] <= ' '; --end) {
        }
        return str.substring(0, end);
    }

    public static String convertBytes(long size) {
        String type;
        long KB = 1024L;
        long MB = 0x100000L;
        long GB = 0x40000000L;
        long TB = 0x10000000000L;
        float convertedSize = 0.0f;
        if (size < 1024L) {
            convertedSize = size;
            type = " Bytes";
        } else if (size < 0x100000L) {
            convertedSize = (float)size / 1024.0f;
            type = " KB";
        } else if (size >= 0x100000L && size < 0x40000000L) {
            convertedSize = (float)size / 1048576.0f;
            type = " MB";
        } else if (size >= 0x40000000L && size < 0x10000000000L) {
            convertedSize = (float)size / 1.0737418E9f;
            type = " GB";
        } else {
            convertedSize = (float)size / 1.0995116E12f;
            type = " TB";
        }
        double sizeInFraction = (double)((int)(((double)convertedSize + 0.005) * 100.0)) / 100.0;
        return sizeInFraction + type;
    }

    public static String addSlashes(String str) {
        if (str == null) {
            return "";
        }
        return str.replace("'", "\\'");
    }

    public static boolean isEqualStrings(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        if (str1 == null && str2 != null) {
            return false;
        }
        return str1.equalsIgnoreCase(str2);
    }

    public static String convertReturnsToLineBreakTags(String withReturns) {
        if (withReturns != null) {
            withReturns = withReturns.replaceAll("<br\r\n/>", "<br />").replaceAll("<br\r/>", "<br />").replaceAll("<br\n/>", "<br />");
            withReturns = withReturns.replaceAll("\r\n", "<br />").replaceAll("\r", "<br />").replaceAll("\n", "<br />");
        }
        return withReturns;
    }

    public static boolean isValidIp(String ipAddr) {
        try {
            char[] ar = ipAddr.toCharArray();
            int c = 0;
            for (int i = 0; i < ar.length; ++i) {
                if (ipAddr.charAt(i) != '.') continue;
                ++c;
            }
            if (c != 3) {
                return false;
            }
            StringTokenizer ipToken = new StringTokenizer(ipAddr, ".");
            return ipToken.countTokens() == 4;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isValidIPAddress(String ip) {
        if (StringUtil.isEmpty(ip)) {
            return false;
        }
        Pattern p = Pattern.compile("^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$");
        Matcher matcher = p.matcher(ip.trim());
        return matcher.matches();
    }

    public static boolean isValidIpRange(String ipRange) {
        String[] range = ipRange.replaceAll("\r\n", "\n").split(",");
        boolean notValid = false;
        boolean invalidSubnet = false;
        block2: for (int i = 0; i < range.length; ++i) {
            notValid = false;
            if (range[i].contains("-")) {
                String[] ips = range[i].split("-");
                if (ips.length != 2) {
                    notValid = true;
                    break;
                }
                for (int j = 0; j < ips.length; ++j) {
                    String ipAddr = ips[j].trim();
                    if (!StringUtil.isValidIp(ipAddr) || j > 1) {
                        notValid = true;
                        continue block2;
                    }
                    if (j != 1 || StringUtil.ip2long(ips[j].trim()) >= StringUtil.ip2long(ips[j - 1].trim())) continue;
                    notValid = true;
                    continue block2;
                }
                continue;
            }
            if (range[i].contains("*")) {
                String ipAddr = range[i].trim().replaceAll("\\*", "100");
                if (StringUtil.isValidIp(ipAddr)) continue;
                notValid = true;
                break;
            }
            if (range[i].contains("/")) {
                String[] temp = range[i].split("/");
                if (!StringUtil.isValidIp(temp[0])) {
                    notValid = true;
                    break;
                }
                if (temp[1].length() > 2) {
                    invalidSubnet = true;
                    break;
                }
                if (temp[1].length() > 2) continue;
                try {
                    if (Long.parseLong(temp[1]) <= 32L) continue;
                    invalidSubnet = true;
                }
                catch (Exception e) {
                    invalidSubnet = true;
                }
                break;
            }
            if (StringUtil.isValidIp(range[i].trim())) continue;
            notValid = true;
            break;
        }
        if (notValid) {
            return false;
        }
        return !invalidSubnet;
    }

    private static long ip2long(String ipAddr) {
        long numformat = 0L;
        StringTokenizer ipToken = new StringTokenizer(ipAddr, ".");
        while (ipToken != null && ipToken.hasMoreTokens()) {
            numformat <<= 8;
            numformat |= Long.parseLong(ipToken.nextToken().trim());
        }
        return numformat;
    }

    public static String escapeNonValidXMLCharacters(String inputString) {
        StringBuffer out = new StringBuffer();
        if (StringUtil.isEmpty(inputString)) {
            return inputString;
        }
        if (inputString == null || "".equals(inputString)) {
            return "";
        }
        for (int i = 0; i < inputString.length(); ++i) {
            char current = inputString.charAt(i);
            if (!(current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd') && (current < '\u10000' || current > '\u10ffff')) continue;
            out.append(current);
        }
        return out.toString();
    }

    public static Set<Long> convertArrayToSet(long[] array) {
        HashSet<Long> set = new HashSet<Long>();
        if (array != null && array.length > 0) {
            for (long i : array) {
                set.add(i);
            }
        }
        return set;
    }

    public static long[] convertListToArray(List<Long> ids) {
        long[] array = new long[ids.size()];
        for (int i = 0; i < ids.size(); ++i) {
            array[i] = ids.get(i);
        }
        return array;
    }

    public static String[] convertListToStringArray(List<String> ids) {
        if (ids == null) {
            return null;
        }
        String[] array = new String[ids.size()];
        for (int i = 0; i < ids.size(); ++i) {
            array[i] = ids.get(i);
        }
        return array;
    }

    public static String[] convertSetToStringArray(Set<String> ids) {
        if (ids == null) {
            return null;
        }
        ArrayList<String> listIds = new ArrayList<String>(ids);
        String[] array = new String[listIds.size()];
        for (int i = 0; i < listIds.size(); ++i) {
            array[i] = (String)listIds.get(i);
        }
        return array;
    }

    public static Set<Long> convertListToSet(List<Long> ids) {
        HashSet<Long> set = new HashSet<Long>();
        for (Long id : ids) {
            set.add(id);
        }
        return set;
    }

    public static long[] convertSetToArray(Set<Long> set) {
        long[] array = null;
        if (set != null && set.size() > 0) {
            array = new long[set.size()];
            int i = 0;
            for (long el : set) {
                array[i++] = el;
            }
        }
        return array;
    }

    public static List<Long> convertSetToList(Set<Long> set) {
        ArrayList<Long> list = new ArrayList<Long>();
        if (set != null && set.size() > 0) {
            for (long el : set) {
                list.add(el);
            }
        }
        return list;
    }

    public static String[] removeElement(String[] input, String deleteMe) {
        ArrayList<String> result = new ArrayList<String>();
        if (input == null || input.length <= 0 || deleteMe == null) {
            return input;
        }
        for (String item : input) {
            if (deleteMe.equalsIgnoreCase(item)) continue;
            result.add(item);
        }
        input = new String[result.size()];
        return result.toArray(input);
    }

    public static List<Long> convertStringToList(String strs, String delimit) {
        ArrayList<Long> values = new ArrayList<Long>();
        if (strs != null) {
            for (String str : strs.split(delimit)) {
                try {
                    values.add(Long.parseLong(str.trim()));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return values;
    }

    public static String convertStringListToString(List<String> list, String delimit) {
        String finalString = "";
        if (list == null) {
            return finalString;
        }
        for (String value : list) {
            finalString = finalString.isEmpty() ? value : finalString + delimit + value;
        }
        return finalString;
    }

    public static String convertStringSetToString(Set<String> list, String delimit) {
        String finalString = "";
        if (list == null) {
            return finalString;
        }
        for (String value : list) {
            finalString = finalString.isEmpty() ? value : finalString + delimit + value;
        }
        return finalString;
    }

    public static String convertLongArrayToString(long[] list, String delimit) {
        String finalString = "";
        long[] lArray = list;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long value = lArray[i];
            finalString = finalString.isEmpty() ? String.valueOf(value) : finalString + delimit + String.valueOf(value);
        }
        return finalString;
    }

    public static String convertLongListToString(List<Long> list, String delimiter) {
        if (list.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (Long element : list) {
            sb.append(element + delimiter);
        }
        sb.delete(sb.length() - delimiter.length(), sb.length());
        return sb.toString();
    }

    public static boolean isContained(String src, String pattern, boolean caseSensitive) {
        if (StringUtil.isEmpty(src)) {
            return false;
        }
        if (StringUtil.isEmpty(pattern)) {
            return true;
        }
        if (src.toLowerCase().contains(pattern.toLowerCase())) {
            return true;
        }
        Pattern p = caseSensitive ? Pattern.compile(pattern) : Pattern.compile(pattern, 2);
        return p.matcher(src).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertStreamToString(InputStream is) throws IOException {
        if (is == null) {
            return "";
        }
        StringWriter writer = new StringWriter();
        char[] buffer = new char[1024];
        try {
            int n;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            while ((n = reader.read(buffer)) != -1) {
                ((Writer)writer).write(buffer, 0, n);
            }
        }
        finally {
            is.close();
        }
        return ((Object)writer).toString();
    }

    public static String escapeRegExWildChars(String searchString) {
        String result = searchString;
        if (result != null && result.trim().length() > 0) {
            result = result.replaceAll("\\\\", "\\\\\\\\");
            result = result.replaceAll("\\.", "\\\\.");
            result = result.replaceAll("\\^", "\\\\^");
            result = result.replaceAll("\\?", "\\\\?");
            result = result.replaceAll("\\|", "\\\\|");
            result = result.replaceAll("\\(", "\\\\(");
            result = result.replaceAll("\\)", "\\\\)");
            result = result.replaceAll("\\[", "\\\\[");
            result = result.replaceAll("\\]", "\\\\]");
            result = result.replaceAll("\\{", "\\\\{");
            result = result.replaceAll("\\}", "\\\\}");
            result = result.replaceAll("\\+", "\\\\+");
            if ((result = result.replaceAll("\\*", "\\\\*")).indexOf("$") != -1) {
                StringBuffer buff = new StringBuffer();
                while (result.indexOf("$") != -1) {
                    buff.append(result.substring(0, result.indexOf("$"))).append("\\$");
                    result = result.substring(result.indexOf("$") + 1);
                }
                if (result.length() > 0) {
                    buff.append(result.trim());
                }
                result = buff.toString().trim();
            }
        }
        return result;
    }

    public static double getDoubleValue(String doubleString) {
        double doubleVal = 0.0;
        try {
            if (!StringUtil.isEmpty(doubleString)) {
                doubleVal = Double.parseDouble(doubleString);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return doubleVal;
    }

    public static List<String> convertStringToListByDelim(String str, String delim) {
        ArrayList<String> stringList = new ArrayList<String>();
        if (!StringUtil.isEmpty(str) && !StringUtil.isEmpty(delim)) {
            for (String st : str.split(delim)) {
                if (StringUtil.isEmpty(st)) continue;
                stringList.add(st.trim());
            }
        }
        return stringList;
    }

    public static String handleDBSpecialChars(String srcStr) {
        if (srcStr == null || srcStr.equals("")) {
            return srcStr;
        }
        return srcStr.replace("_", "\\_").replace("%", "\\%");
    }

    public static boolean isNumeric(String number) {
        if (StringUtil.isEmpty(number)) {
            return false;
        }
        Pattern p = Pattern.compile("\\d+");
        Matcher matcher = p.matcher(number.trim());
        return matcher.matches();
    }

    public static boolean isRestrictSpChar(String word) {
        if (StringUtil.isEmpty(word)) {
            return false;
        }
        Pattern p = Pattern.compile("[a-zA-Z0-9-:&()/#@,\\._ ]*");
        Matcher matcher = p.matcher(word.trim());
        return matcher.matches();
    }
}

